import pandas as pd  
import pickle 
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  

good_credit_history = credit_customers['credit_history'].isin(['existing paid', 'all paid'])     
age_group = (credit_customers['age'] >= 25) & (credit_customers['age'] <= 45)     
stable_employment = credit_customers['employment'].isin(['>=7', '4<=X<7'])    
target_customers = credit_customers[good_credit_history & age_group & stable_employment] 

print("target_customers:\n", target_customers)    
pickle.dump(target_customers,open("./ref_result/target_customers.pkl","wb"))